/*
 *  imagehandler.c
 *  
 *
 *  Created by Charles Mercadal on Tue Dec 09 2003.
 *
 */

#include <stdio.h>

#include "common.h"
#include "cmfgetln.h"
#include "parsefunctions.h"


static void printFullImage(void);


void endImageHandler(char *);
void heightHandler(char *);
void urlHandler(char *);
void widthHandler(char *);


static char *height;
static char *url;
static char *width;


void printFullImage(void)
{

    if (height && width && url)
        (void)printf("<img src=\"%s\" height=\"%s\" width=\"%s\">", url, height, width);
    else if (url)
        (void)printf("<img src=\"%s\">", url);
    else
        (void)fprintf(stderr, "<image> tag format corrupted or missing image <url> tag\n");
    
    if (height)
        free(height);
    if (width)
        free(width);
    if (url)
        free(url);
    
    height = width = url = NULL;
}


void heightHandler(char *print)
{
    char *minbuf;
    
    
    minbuf = cmfgettoch(stdin, '<');
    height = xstrdup(minbuf);
    free(minbuf);
    
    (void)printf("%s", print);

    parseTag();
}


void widthHandler(char *print)
{
    char *minbuf;
    
    
    minbuf = cmfgettoch(stdin, '<');
    width = xstrdup(minbuf);
    free(minbuf);
    
    (void)printf("%s", print);

    
    parseTag();
}


void urlHandler(char *print)
{
    char *minbuf;
    

    minbuf = cmfgettoch(stdin, '<');
    url = xstrdup(minbuf);
    free(minbuf);
    
    (void)printf("%s", print);
    
    parseTag();
}


void endImageHandler(char *print)
{
    
    printFullImage();
    
    (void)printf("%s", print);
}
