/*
 *  linktitlehandler.c
 *  
 *
 *  Created by Charles Mercadal on Tue Dec 09 2003.
 *
 */

#include <stdio.h>

#include "common.h"
#include "cmfgetln.h"
#include "parsefunctions.h"


static void printLinkTitle(void);


void linkHandler(char *);
void titleHandler(char *);


static char *linkloc;
static char *title;


void titleHandler(char *print)
{
    char *minbuf;


    minbuf = cmfgettoch(stdin, '<');
    title = xstrdup(minbuf);
    free(minbuf);
    
    (void)printf("%s", print);

    if (linkloc != NULL)
        printLinkTitle();

    parseTag(); /* parse the closing tag that's left */
}


void linkHandler(char *print)
{
    char *minbuf;


    minbuf = cmfgettoch(stdin, '<');
    linkloc = xstrdup(minbuf);
    free(minbuf);
    
    (void)printf("%s", print);

    if (title != NULL)
        printLinkTitle();
    
    parseTag(); /* parse close tag left */
}


void printLinkTitle(void)
{

    (void)printf("<a href=\"%s\">%s</a>\n", linkloc, title);
    free(linkloc);
    free(title);
    
    /* Reset, linkHandler & titleHandler assume a href is printed */
    linkloc = title = NULL;
}
