/*
 * main.c
 *  
 *
 * Created by mercadal on Fri Feb 01 2002.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "cmfgetln.h"
#include "common.h"
#include "parsefunctions.h"


void usage(void);
void runParse(void);


int main(int argc, char *argv[])
{
    char *inname, *oname, qflag, *udefname;
    extern char *optarg;
    int ch;
    FILE *udeffile;
    
    
    qflag = 0;
    inname = oname = udefname = NULL;
    udeffile = NULL;
    
    while ((ch = getopt(argc, argv, "i:o:u:q")) != -1)
        switch (ch) {
            case 'i':
                inname = xstrdup(optarg);
                break;
            case 'o':
                oname = xstrdup(optarg);
                break;
            case 'q':
                qflag = 1;
                break;
            case 'u':
                udefname = xstrdup(optarg);
                break;
            case '?':
            case 'v':
            default:
                usage();
                /* NOTREACHED */
        }

    if (inname != NULL)
        if ((freopen(inname, "r", stdin)) == NULL) {
            perror(inname);
            exit(1);
        }


    if (oname != NULL)
        if ((freopen(oname, "w", stdout)) == NULL) {
            perror(oname);
            exit(1);
        }
    

    if (udefname != NULL)
        if ((udeffile = fopen(udefname, "r")) == NULL) {
            perror(udefname);
            exit(1);
        }

    (void)printf("<!--HTML output by rss2html from %s-->\n", (inname) ? inname : "the standard input");
    
    if (inname)
        free(inname);
    if (oname)
        free(oname);
    if (udefname)
        free(udefname);

    initializeTags(udeffile, qflag);
    runParse();
    uninitializeTags();

    return 0;
}


void runParse(void)
{
    register int ch;
    
    
    while ((ch = getchar()) != EOF) {
        if (ch == '<')
            parseTag();
        else
            (void)putchar(ch);
    }
}


void usage(void)
{

    (void)fprintf(stderr, "usage:  rss2html [-q] [-i infile] [-o outfile] [-u user defined tag file]\nQuestions?  mercadal@khons.diablonet.net\n");
    exit(1);
}
